/*
*******************************************************************************
*
* File:         pxdata.h
* Description:  
* Author:       Henrik Liebau
* Created:      05 Apr 2000, 09:24:07
* Modified:     Wed Jun  7 11:53:58 2000 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxdata_H__
#define __pxdata_H__

/* include type definitions, if not already done */
#ifndef __pxdatdef_H__
#include <pxdatdef.h>
#endif /* defined __pxdatdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*###########################################################################*
 * externally visible functions
 *###########################################################################*/

/*---------------------------------------------------------------------------*
 * EXPORT bx_errtype BestXPprGenInfoGet (
 *
 * Purpose	: get generic info about PPR parameters
 *---------------------------------------------------------------------------*/
EXPORT bx_errtype BestXPprGenInfoGet (
  bx_handletype          handle,
  bx_int32        param,   /* what kind of param block at all */
  const bx_generic_infotype ** geninfo    /* the info struct */
  );

/*---------------------------------------------------------------------------*
 * EXPORT bx_errtype BestXPprParamInfoGet (
 *
 * Purpose	: get param info about ppr parameters
 *---------------------------------------------------------------------------*/
EXPORT bx_errtype BestXPprParamInfoGet (
  bx_handletype        handle,
  bx_int32      param,
  bx_int32             prop,
  const bx_param_infotype ** parinfo,
  bx_int32             option
  );

/*###########################################################################*
 * dll-wide functions
 *###########################################################################*/

/*---------------------------------------------------------------------------*
 * bx_errtype PprNew ( void ** newPtr, size_t num, size_t elSize );
 *
 * Purpose	: initialize newPtr for storage and init w/ zeroes.
 * Returns	: BX_E_HOST_MEM_FULL on failure
 *---------------------------------------------------------------------------*/
bx_errtype PprNew ( void ** newPtr, size_t num, size_t elSize );

/*---------------------------------------------------------------------------*
 * bx_errtype PprRenew ( void ** renewPtr, size_t newnum, size_t elSize );
 *
 * Purpose	: re-initialize RenewPtr w/ new size 
 * Returns	: BX_E_HOST_MEM_FULL on failure
 *---------------------------------------------------------------------------*/
bx_errtype PprRenew ( void ** renewPtr, size_t newnum, size_t elSize );
  
/*---------------------------------------------------------------------------*
 * void PprDelete ( void ** freePtr );
 *
 * Purpose	: delete (free) storage for ptr and set ptr to zero
 *---------------------------------------------------------------------------*/
void PprDelete ( void ** freePtr );

/*---------------------------------------------------------------------------*
 * bx_errtype PprDataNew (bx_handletype handle, bxppr_datatype ** pprData);
 *
 * Purpose	: initialize data structures for handle
 *---------------------------------------------------------------------------*/
bx_errtype PprDataNew (bx_handletype handle);
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprDataDelete (bx_handletype handle, bxppr_datatype ** pprData)
 *
 * Purpose	: delete data structures for handle
 *---------------------------------------------------------------------------*/
bx_errtype PprDataDelete (bx_handletype handle);

/*---------------------------------------------------------------------------*
 * bx_errtype PprDataGet (bx_handletype handle, bxppr_datatype ** pprData);
 *
 * Purpose	: check handle, retrieve ppr data for the handle,
 *                lock handle and data
 *---------------------------------------------------------------------------*/
bx_errtype PprDataGet (bx_handletype handle, bxppr_datatype ** pprData);
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprDataRelease (bx_handletype handle, bxppr_datatype ** pprData)
 *
 * Purpose	: unlock data and associated handle
 *---------------------------------------------------------------------------*/
bx_errtype PprDataRelease (bx_handletype handle, bxppr_datatype ** pprData);

/*---------------------------------------------------------------------------*
 * bx_errtype PprResultInit ( bxppr_resulttype * result,
 *
 * Purpose	: initializes result; NOTE: does not allocate storage for a
 *		  bxppr_resulttype!
 *---------------------------------------------------------------------------*/
bx_errtype PprResultInit ( bxppr_resulttype * result,
			      bxppr_vardatatype * varData );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprResultDelete ( bxppr_resulttype * result )
 *
 * Purpose	: delete contents of result. NOT: does not deallocate
 *		  storage for bxppr_resulttype!
 *---------------------------------------------------------------------------*/
bx_errtype PprResultDelete ( bxppr_resulttype * result );

/*---------------------------------------------------------------------------*
 * bx_errtype PprBehResultDataInit ( bxppr_behresulttype * behresult,
 *
 * Purpose	: initializes behresult; NOTE: does not allocate storage for a
 *		  bxppr_behresulttype!
 *---------------------------------------------------------------------------*/
bx_errtype PprBehResultDataInit ( bxppr_behresultdatatype * behresult,
				 bxppr_vardatatype * varData );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprBehResultDataDelete ( bxppr_behresulttype * behresult )
 *
 * Purpose	: delete contents of behresult. NOT: does not deallocate
 *		  storage for bxppr_behresulttype!
 *---------------------------------------------------------------------------*/
bx_errtype PprBehResultDataDelete ( bxppr_behresultdatatype * behresult );

/*---------------------------------------------------------------------------*
 * bx_errtype PprBlkResultDataDelete ( bxppr_blkResulttype * blkResult )
 *
 * Purpose	: delete contents of blkResult. NOT: does not deallocate
 *		  storage for bxppr_blkResulttype!
 *---------------------------------------------------------------------------*/
bx_errtype PprBlkResultDataDelete ( bxppr_blkresultdatatype * blkResult );

/*---------------------------------------------------------------------------*
 * void PprResultDataInit ( bxppr_resultdatatype * result )
 *
 * Purpose	: initialize structure w/ all zeroes
 *---------------------------------------------------------------------------*/
bx_errtype PprResultDataInit ( bxppr_resultdatatype * result );

/*---------------------------------------------------------------------------*
 * void PprResultDataDelete ( bxppr_resultdatatype * result )
 *
 * Purpose	: delete contents of result. NOT: does not deallocate
 *		  storage for bxppr_resultdatatype!
 *---------------------------------------------------------------------------*/
void PprResultDataDelete ( bxppr_resultdatatype * result );

/*---------------------------------------------------------------------------*
 * PprPropVal2Str (const bx_param_stringlisttype * thelist, bx_int32 value)
 *
 * Purpose	: get string from value
 *---------------------------------------------------------------------------*/
void PprPropVal2Str ( const bx_param_stringlisttype * thelist,
		      bx_int32 value,
		      bx_charptrtype retStr );

/*---------------------------------------------------------------------------*
 * PprPropStr2Val (const bx_param_stringlisttype * thelist,
 *
 * Purpose	: get value from string
 *---------------------------------------------------------------------------*/
bx_errtype PprPropStr2Val ( const bx_param_stringlisttype * thelist,
			    const bx_charptrtype valstr,
			    bx_int32 * retVal );
#ifdef __cplusplus
}
#endif

#endif /* defined __pxdata_H__ */
